#!/bin/bash

# Usage: ./mhv_deploy.sh --staging-dir /opt/stage/2018.2.1.0 --address t3://127.0.0.1:7201 --user weblogic --target mhvServicesCluster

OPTIND=1         # Reset in case getopts has been used previously in the shell.

# Initialize our own variables:
STAGING_DIR=""
WLS_ADMIN_USERNAME="AI"
WLS_ADMIN_PASSWORD=""
WLST_URI=""
WLS_TARGET=""

POSITIONAL=()
while [[ $# -gt 0 ]]
do
key="$1"

case $key in
    -sd|--staging-dir)
    STAGING_DIR="$2"
    shift # past argument
    shift # past value
    ;;
    -a|--address)
    WLST_URI="$2"
    shift # past argument
    shift # past value
    ;;
    -t|--target)
    WLS_TARGET="$2"
    shift # past argument
    shift # past value
    ;;
    -u|--user)
    WLS_ADMIN_USERNAME="$2"
    shift # past argument
    shift # past value
    ;;
    --default)
    DEFAULT=YES
    shift # past argument
    ;;
    *)    # unknown option
    POSITIONAL+=("$1") # save it in an array for later
    shift # past argument
    ;;
esac
done
set -- "${POSITIONAL[@]}" # restore positional parameters

shift $((OPTIND-1))

[ "$1" = "--" ] && shift

echo "Beginning deployment of all files in location: '${STAGING_DIR}'."
echo
echo "#########################################################################"
echo "##                                                                       "
echo "## Weblogic Server Hosted @ '${WLST_URI}'."
echo "## Weblogic Admin Username: '${WLS_ADMIN_USERNAME}'."
echo "## WebLogic Target: '${WLS_TARGET}'."
echo "##                                                                       "
echo "#########################################################################"
echo
echo
echo -n "Please enter WebLogic Admin Password: "
read -s WLS_ADMIN_PASSWORD
echo

for DEPLOYMENT_FILE_PATH in ${STAGING_DIR}/*.war; do
	DEPLOYMENT=${DEPLOYMENT_FILE_PATH##*/}
	APP_NAME="$(cut -d- -f1-4 <<<${DEPLOYMENT})"
	echo "Undeploying existing application from target system."
	#echo "${MW_HOME}/wlserver/common/bin/wlst.sh wls-undeploy.py ${WLS_ADMIN_USERNAME} *************** ${WLST_URI} ${APP_NAME}"
	${MW_HOME}/wlserver/common/bin/wlst.sh wls-undeploy.py ${WLS_ADMIN_USERNAME} ${WLS_ADMIN_PASSWORD} ${WLST_URI} ${APP_NAME}	
	
	echo "Deploying application ${DEPLOYMENT} to WebLogic application server."
	${MW_HOME}/wlserver/common/bin/wlst.sh wls-manage-application.py -u ${WLS_ADMIN_USERNAME} -p ${WLS_ADMIN_PASSWORD} -a ${WLST_URI} -n ${DEPLOYMENT} -f ${DEPLOYMENT_FILE_PATH} -t ${WLS_TARGET}
done



